package com.takedata.resume.config;

import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

/**
 * @Author: wy
 * @Date: Created in 13:06 2019/12/13
 * @Description: ES相关配置类
 * @Modified: By：
 */
@Slf4j
@Configuration
@EnableConfigurationProperties(ElasticsearchProperties.class)
@ConditionalOnProperty(prefix = "resume.elasticsearch", name = "enable", havingValue = "true")
public class ElasticsearchConfig {

    @Bean
    public RestHighLevelClient restHighLevelClient(ElasticsearchProperties elasticsearchProperties) {
        //解析host
        List<String> hosts = elasticsearchProperties.getHosts();
        HttpHost[] httpHosts = new HttpHost[hosts.size()];
        for (int i = 0; i < hosts.size(); i++) {
            String s = hosts.get(i);
            String[] split = s.split(":");
            if (split.length != 2) {
                String msg = "resume.elasticsearch.hosts 格式错误!";
                log.error(msg);
                throw new RuntimeException(msg);
            }
            httpHosts[i] = new HttpHost(split[0], Integer.parseInt(split[1]));
        }
        RestHighLevelClient restHighLevelClient = new RestHighLevelClient(RestClient.builder(httpHosts));
        log.info("RestHighLevelClient start success,host: {}", hosts);
        return restHighLevelClient;
    }


}
