package com.takedata.resume.common.utils;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.OSSObject;

import java.io.*;

/**
 * @Author: wy
 * @Date: Created in 10:11 2019/12/10
 * @Description: 文件工具类
 * @Modified: By：
 */
public class OssFileUtils {

    private final static String endpoint = "oss-cn-hangzhou.aliyuncs.com";
    private final static String accessKeyId = "LTAI4FfyoTunkVk7QrMQEsY4";
    private final static String accessKeySecret = "gC2xIAvddBcnmqZeLEK8DMtnUdyz1O";
    private final static String bucketName = "forprogrammers";

    /**
     * oss普通下载
     *
     * @param objectName ${E.g}:"resume/1575602066160.doc"
     */
    public static byte[] ossDownload(String objectName) {
        byte[] bytes;
        try {
            // 创建OSSClient实例。
            OSS ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);
            // ossObject包含文件所在的存储空间名称、文件名称、文件元信息以及一个输入流。
            OSSObject ossObject = ossClient.getObject(bucketName, objectName);
            InputStream inputStream = ossObject.getObjectContent();
            bytes = inStreamToByteArray(inputStream);
        } catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        return bytes;
    }


    /**
     * 输入流转字节数组
     *
     * @param inStream 输入流
     * @return 字节数组
     * @throws IOException
     */
    public static byte[] inStreamToByteArray(InputStream inStream) throws IOException {
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[512];
        int rc = 0;
        while ((rc = inStream.read(buff, 0, 512)) > 0) {
            swapStream.write(buff, 0, rc);
        }
        return swapStream.toByteArray();
    }
}

