package com.takedata.resume.common;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Paging<T> implements Serializable {
    protected Long total;
    protected List<T> data;

    public Paging() {
    }

    public Paging(Long var1, List<T> var2) {
        this.total = var1;
        this.data = var2;
    }

    public Boolean isEmpty() {
        return Objects.equals(0L, this.total) || this.data == null || this.data.isEmpty();
    }

    public static <T> Paging<T> empty(Class<T> var0) {
        List var1 = Collections.emptyList();
        return new Paging(0L, var1);
    }

    public static <T> Paging<T> empty() {
        return new Paging(0L, Collections.emptyList());
    }

    public Long getTotal() {
        return this.total;
    }

    public List<T> getData() {
        return this.data;
    }

    public void setTotal(Long var1) {
        this.total = var1;
    }

    public void setData(List<T> var1) {
        this.data = var1;
    }
}
