package com.takedata.resume.api;

import java.io.IOException;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.takedata.resume.common.Response;
import com.takedata.resume.model.ResumeResult;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Consts;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

@Slf4j
public class TestParseService {

    private final static String url = "http://www.resumesdk.com/api/parse";
    private final static int uid = 1912050;        //替换为你的用户名（int格式）
    private final static String pwd = "hOxKG1";    //替换为你的密码（String格式）

    /**
     * 解析简历
     *
     * @param bytes    文件字节数组
     * @param fileName 文件名
     * @return
     */
    public static Response<ResumeResult> testResumeParser(byte[] bytes, String fileName) {
        try {
            // 设置头字段
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("content-type", "application/json");
            // 读取简历内容
            String data = new String(Base64.encodeBase64(bytes), Consts.UTF_8);
            // 设置内容信息
            JSONObject json = new JSONObject();
            json.put("uid", uid);            // 用户id
            json.put("pwd", pwd);            // 用户密码
            json.put("file_name", fileName);    // 文件名
            json.put("file_cont", data);    // 经base64编码过的文件内容
            StringEntity params = new StringEntity(json.toString(), Consts.UTF_8);
            httpPost.setEntity(params);
            // 发送请求
            HttpClient httpclient = HttpClientBuilder.create().build();
            HttpResponse response = httpclient.execute(httpPost);
            // 处理返回结果
            String resCont = EntityUtils.toString(response.getEntity(), Consts.UTF_8);
            JSONObject res = new JSONObject(resCont);
            JSONObject status = res.getJSONObject("status");
            if (status.getInt("code") != 200) {
                log.error("request failed: code=<" + status.getInt("code") + ">, message=<" + status.getString("message") + ">");
                return Response.no(400);
            } else {
                JSONObject acc = res.getJSONObject("account");
                log.info("usage_remaining:" + acc.getInt("usage_remaining"));
                JSONObject result = res.getJSONObject("result");
                ResumeResult resumeResult = JSON.parseObject(result.toString(), new TypeReference<ResumeResult>() {
                });
                return Response.yes(resumeResult);
            }
        } catch (IOException e) {
            log.error("error:{}", e.getMessage());
            return Response.no(400);
        }
    }

}
